<?php
/*--------------------------------------------------------------------
 OnGetShippingLinkEvent.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/
namespace Gambio\Shop\SellingUnit\Database\Unit\Events;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Core\Events\SellingUnitEventTrait;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetShippingLinkEventInterface;
use Gambio\Shop\SellingUnit\Unit\Builders\Interfaces\SellingUnitBuilderInterface;
use Gambio\Shop\SellingUnit\Unit\Builders\SellingUnitBuilder;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ShippingLink;
use PriceDataInterface;

/**
 * Class OnGetShippingLinkEvent
 * @package Gambio\Shop\SellingUnit\Database\Unit\Events
 */
class OnGetShippingLinkEvent implements OnGetShippingLinkEventInterface
{
    use SellingUnitEventTrait;
    
    /**
     * @var SellingUnitBuilderInterface
     */
    protected $builder;
    
    /**
     * @var ProductId
     */
    protected $productId;
    
    /**
     * @var ModifierIdentifierCollectionInterface
     */
    protected $modifiers;
    
    /**
     * @var ShippingLink
     */
    protected $shippingLink;
    
    
    /**
     * OnSellingUnitCreateEvent constructor.
     *
     * @param                                       $product
     * @param ProductId                             $productId
     * @param ModifierIdentifierCollectionInterface $modifiers
     * @param PriceDataInterface                   $xtcPrice
     */
    public function __construct(
        $product,
        ProductId $productId,
        ModifierIdentifierCollectionInterface $modifiers,
        PriceDataInterface $xtcPrice
    ) {
    
        $this->product   = $product;
        $this->productId = $productId;
        $this->modifiers = $modifiers;
        $this->xtcPrice  = $xtcPrice;
        $this->builder   = new SellingUnitBuilder;
    }
    
    
    /**
     * @inheritDoc
     */
    public function builder(): SellingUnitBuilderInterface
    {
        return $this->builder;
    }
    
    
    /**
     * @inheritDoc
     */
    public function productId(): ProductId
    {
        return $this->productId;
    }
    
    
    /**
     * @inheritDoc
     */
    public function modifiers(): ModifierIdentifierCollectionInterface
    {
        return $this->modifiers;
    }
    
    
    /**
     * @inheritDoc
     */
    public function shippingLink(): ShippingLink
    {
        return $this->shippingLink;
    }
    
    
    /**
     * @inheritDoc
     */
    public function setShippingLink(ShippingLink $shippingLink): void
    {
        $this->shippingLink = $shippingLink;
    }
}